/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidor;

import jalis.apoio.servidor.IServidor;
import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.relatorios.apoio.RelatorioConferenciaEnviados;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.imageio.stream.FileImageInputStream;

public class ServidorImpl
extends UnicastRemoteObject
implements IServidor {
    static final long serialVersionUID = -8764249867714751755L;
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    BufferedWriter log = null;
    String imagemSuporte = "";
    boolean enviarParcial = false;

    public ServidorImpl(BufferedWriter buf, String imagemSuporte, boolean enviarParcial) throws RemoteException {
        super(4445);
        if (buf != null) {
            this.log = buf;
        }
        this.imagemSuporte = imagemSuporte;
        this.enviarParcial = enviarParcial;
    }

    private void escreverLog(String mensagem) {
        if (this.log != null) {
            try {
                this.log.write(mensagem + "\n");
                this.log.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean validaCliente(String codigoFilial, String codigoCliente) throws RemoteException, SQLException {
        boolean retorno = false;
        if (Funcoes.textoVazio(codigoFilial)) {
            return false;
        }
        if (!Funcoes.isNumeric(codigoCliente) || Long.parseLong(codigoCliente) != ParametrosGerais.getCodigoCliente()) {
            this.escreverLog("Codigo incorreto ao validar cliente");
            return false;
        }
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder("select fil_codigo from filiais_postocoleta where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and fil_apoio = true");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        retorno = rs.next() && !DBUtil.campoNull(rs.getString("fil_codigo"));
        Conexao.fecharStatement(st);
        this.escreverLog(retorno ? "Cliente validado com sucesso" : "Filial nao encontrada ao validar cliente");
        return retorno;
    }

    @Override
    public String getFiliais(String codigoCliente) throws RemoteException, SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select fil_codigo, fil_descricao from filiais_postocoleta ");
        buf.append("where fil_apoio = true ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        buf.delete(0, buf.length());
        buf.append("<filiais>");
        while (rs.next()) {
            buf.append("<filial><codigo>").append(rs.getInt("fil_codigo"));
            buf.append("</codigo><descricao>").append(rs.getString("fil_descricao"));
            buf.append("</descricao></filial>");
        }
        buf.append("</filiais>");
        Conexao.fecharStatement(st);
        this.escreverLog("Obtendo filiais para configuracao de cliente");
        return buf.toString();
    }

    @Override
    public boolean validaConvenio(String codigoFilial, String codigoConvenio) throws RemoteException, SQLException {
        if (codigoFilial == null || codigoConvenio == null) {
            this.escreverLog("Erro ao validar o convenio " + codigoConvenio + " para a filial " + codigoFilial);
            return false;
        }
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder("select con_codigo from convenios where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and con_codigo = ");
        bui.append(codigoConvenio);
        bui.append(" and con_labapoio = true ");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        boolean retorno = rs.next();
        Conexao.fecharStatement(st);
        this.escreverLog("Convenio " + codigoConvenio + (retorno ? "" : " NAO") + " validado na filial " + codigoFilial);
        return retorno;
    }

    @Override
    public String getNomeConvenio(String codigoFilial, String codigoConvenio) throws RemoteException, SQLException {
        if (codigoFilial == null || codigoConvenio == null) {
            this.escreverLog("Erro ao obter o nome do convenio " + codigoConvenio + " para a filial " + codigoFilial);
            return "";
        }
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder("select con_razao, con_apoiodias from convenios where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and con_codigo = ");
        bui.append(codigoConvenio);
        bui.append(" and con_labapoio = true ");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        String retorno = "";
        if (rs.next()) {
            retorno = "<convenio>";
            retorno = retorno + StringUtil.getTag("nome", rs.getString("con_razao"));
            retorno = retorno + StringUtil.getTag("dias", String.valueOf(rs.getInt("con_apoiodias")));
            retorno = retorno + "</convenio>";
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    @Override
    public String getExames(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder();
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        ArrayList<String> exames = new ArrayList<String>();
        this.escreverLog("Obtendo exames para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        if (primeiraConexao) {
            buf.append("select a.exa_codigo from exames a ");
            buf.append("where a.fil_codigo = ");
            buf.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                exames.add(rs.getString("exa_codigo"));
            }
        } else {
            try {
                String[] lista;
                buf.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "exames"));
                for (String s : lista = StringUtil.getValores(buf.toString(), "exame")) {
                    String temp = StringUtil.getValor(s, "codigo");
                    if (Funcoes.textoVazio(temp)) continue;
                    exames.add(temp);
                }
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                exames.clear();
            }
        }
        if (!exames.isEmpty()) {
            retorno.append(this.getExames(codigoFilial, codigoConvenio, exames.toArray(new String[exames.size()])));
        } else {
            retorno.append("<exames></exames>");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.toString();
    }

    private String pegaPrazoEntregaConvenio(String codigoFilial, String prazoOriginal, String exame, String material, String convenio) throws SQLException {
        String retorno = prazoOriginal;
        this.escreverLog("Obtendo prazo de entrega para o convenio " + convenio + " na filial " + codigoFilial + " para o exame " + exame + " e o prazo original " + prazoOriginal);
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select prz_codigo from examematconvenioprazo where fil_codigo = ").append(codigoFilial);
        buf.append(" and exa_codigo = '").append(exame).append("' ");
        buf.append(" and mco_codigo = ").append(material);
        buf.append(" and con_codigo = ").append(convenio);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            retorno = rs.getString("prz_codigo");
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private String xmlExame(String filial, String codigoConvenio, String exame) throws SQLException {
        StringBuilder retorno = new StringBuilder();
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        this.escreverLog("Obtendo xml do exame " + exame + " para o convenio " + codigoConvenio + " na filial " + filial);
        StringBuilder buf = new StringBuilder();
        buf.append("select a.exa_codigo, a.exa_descricao, a.exa_sexo, a.exa_horaentrada, ");
        buf.append("a.exa_horasaida, a.exa_filtro, a.exa_diagnostico, a.exa_interferencia, a.exa_sinonimo, ");
        buf.append("a.exa_idademax, a.exa_idademin, a.exa_idademaxtipo, a.exa_idademintipo, ");
        buf.append("a.exa_qtdeamostras, a.exa_autorizacao, a.exa_proibido ");
        buf.append("from exames a ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and exa_codigo = '");
        buf.append(exame);
        buf.append("'");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        while (rs.next()) {
            retorno.append("<exame><codigoexame>");
            retorno.append(rs.getString("exa_codigo"));
            retorno.append("</codigoexame><descricao>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_descricao")));
            retorno.append("</descricao><sexo>");
            retorno.append(rs.getString("exa_sexo"));
            retorno.append("</sexo><horaentrada>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_horaentrada")) ? "null" : rs.getString("exa_horaentrada"));
            retorno.append("</horaentrada><horasaida>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_horasaida")) ? "null" : rs.getString("exa_horasaida"));
            retorno.append("</horasaida><filtro>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_filtro")));
            retorno.append("</filtro><diagnostico>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_diagnostico")));
            retorno.append("</diagnostico><interferencia>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_interferencia")));
            retorno.append("</interferencia><sinonimo>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_sinonimo")));
            retorno.append("</sinonimo><idademax>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_idademax")) ? "null" : rs.getString("exa_idademax"));
            retorno.append("</idademax><idademin>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_idademin")) ? "null" : rs.getString("exa_idademin"));
            retorno.append("</idademin><idademaxtipo>");
            retorno.append(rs.getString("exa_idademaxtipo"));
            retorno.append("</idademaxtipo><idademintipo>");
            retorno.append(rs.getString("exa_idademintipo"));
            retorno.append("</idademintipo><qtdeamostras>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_qtdeamostras")) ? "null" : rs.getString("exa_qtdeamostras"));
            retorno.append("</qtdeamostras><autorizacao>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_autorizacao")));
            retorno.append("</autorizacao><proibido>");
            retorno.append(rs.getBoolean("exa_proibido") ? TRUE : FALSE);
            retorno.append("</proibido><setores>");
            buf.delete(0, buf.length());
            buf.append("select exa_codigo, set_codigo, ese_default from examesetor where fil_codigo = ");
            buf.append(filial);
            buf.append(" and exa_codigo = '");
            buf.append(rs.getString("exa_codigo"));
            buf.append("'");
            ResultSet rs2 = Conexao.executeQuery(st2, buf.toString());
            while (rs2.next()) {
                retorno.append("<setor><codigoexame>");
                retorno.append(rs2.getString("exa_codigo"));
                retorno.append("</codigoexame><codigosetor>");
                retorno.append(rs2.getString("set_codigo"));
                retorno.append("</codigosetor><default>");
                retorno.append(rs2.getBoolean("ese_default") ? TRUE : FALSE);
                retorno.append("</default></setor>");
            }
            retorno.append(Util.criaXML("setor", rs2));
            retorno.append("</setores>");
            retorno.append("<materiais>");
            buf.delete(0, buf.length());
            buf.append("select a.exa_codigo, a.mco_codigo, a.emc_default, a.emc_pergunta, a.emc_preparo, a.emc_instrcoleta, a.");
            buf.append("emc_prepamostra, a.emc_inadequada, a.prz_codigo, a.met_codigo, a.emc_ordem, a.emc_pagina, a.");
            buf.append("emc_conservacao, a.emc_diasconserva, a.emc_temperaturainicial, a.emc_temperaturafinal, a.");
            buf.append("emc_referencia, a.emc_solicitarjejum, a.emc_obrigamedicamento, a.");
            buf.append("emc_marcarexterno, a.emc_obrigadum, a.emc_obrigapeso, a.emc_obrigaaltura, a.emc_obrigavolume, a.emc_obrigatempodiurese, ");
            buf.append("b.prz_descricao, c.met_descricao, d.mco_descricao ");
            buf.append("from examematcoleta a ");
            buf.append("left join prazoentrega b on a.fil_codigo = b.fil_codigo and a.prz_codigo = b.prz_codigo ");
            buf.append("left join metodologia c on a.fil_codigo = c.fil_codigo and a.met_codigo = c.met_codigo ");
            buf.append("left join materialcoleta d on a.fil_codigo = c.fil_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.exa_codigo = '");
            buf.append(rs.getString("exa_codigo"));
            buf.append("'");
            buf.append(" and (a.emc_proibidoapoio is null OR a.emc_proibidoapoio = false) ");
            rs2 = Conexao.executeQuery(st2, buf.toString());
            while (rs2.next()) {
                retorno.append("<material><codigoexame>");
                retorno.append(rs2.getString("exa_codigo"));
                retorno.append("</codigoexame><codigomaterial>");
                retorno.append(rs2.getString("mco_codigo"));
                retorno.append("</codigomaterial><descricaomaterial>");
                retorno.append(rs2.getString("mco_descricao"));
                retorno.append("</descricaomaterial><default>");
                retorno.append(rs2.getBoolean("emc_default") ? TRUE : FALSE);
                retorno.append("</default><pergunta>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_pergunta")));
                retorno.append("</pergunta><preparo>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_preparo")));
                retorno.append("</preparo><prepamostra>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_prepamostra")));
                retorno.append("</prepamostra><instrcoleta>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_instrcoleta")));
                retorno.append("</instrcoleta><inadequada>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_inadequada")));
                retorno.append("</inadequada><codigoprazo>");
                retorno.append(this.pegaPrazoEntregaConvenio(filial, rs2.getString("prz_codigo"), rs2.getString("exa_codigo"), rs2.getString("mco_codigo"), codigoConvenio));
                retorno.append("</codigoprazo><codigometodo>");
                retorno.append(rs2.getString("met_codigo"));
                retorno.append("</codigometodo><ordem>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_ordem")) ? "null" : rs2.getString("emc_ordem"));
                retorno.append("</ordem><pagina>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_pagina")) ? "null" : rs2.getString("emc_pagina"));
                retorno.append("</pagina><conservacao>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_conservacao")));
                retorno.append("</conservacao><diasconserva>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_diasconserva")) ? "null" : rs2.getString("emc_diasconserva"));
                retorno.append("</diasconserva><temperaturainicial>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_temperaturainicial")) ? "null" : rs2.getString("emc_temperaturainicial"));
                retorno.append("</temperaturainicial><temperaturafinal>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_temperaturafinal")) ? "null" : rs2.getString("emc_temperaturafinal"));
                retorno.append("</temperaturafinal><referencia>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_referencia")));
                retorno.append("</referencia><solicitarjejum>");
                retorno.append(rs2.getBoolean("emc_solicitarjejum") ? TRUE : FALSE);
                retorno.append("</solicitarjejum><obrigamedicamento>");
                retorno.append(rs2.getBoolean("emc_obrigamedicamento") ? TRUE : FALSE);
                retorno.append("</obrigamedicamento><marcarexterno>");
                retorno.append(rs2.getBoolean("emc_marcarexterno") ? TRUE : FALSE);
                retorno.append("</marcarexterno><obrigadum>");
                retorno.append(rs2.getBoolean("emc_obrigadum") ? TRUE : FALSE);
                retorno.append("</obrigadum><obrigapeso>");
                retorno.append(rs2.getBoolean("emc_obrigapeso") ? TRUE : FALSE);
                retorno.append("</obrigapeso><obrigaaltura>");
                retorno.append(rs2.getBoolean("emc_obrigaaltura") ? TRUE : FALSE);
                retorno.append("</obrigaaltura><obrigavolume>");
                retorno.append(rs2.getBoolean("emc_obrigavolume") ? TRUE : FALSE);
                retorno.append("</obrigavolume><obrigatempodiurese>");
                retorno.append(rs2.getBoolean("emc_obrigatempodiurese") ? TRUE : FALSE);
                retorno.append("</obrigatempodiurese><descricaoprazo>");
                retorno.append(rs2.getString("prz_descricao"));
                retorno.append("</descricaoprazo><descricaometodo>");
                retorno.append(rs2.getString("met_descricao"));
                retorno.append("</descricaometodo>");
                buf.delete(0, buf.length());
                buf.append("select exa_codigo, mco_codigo, prc_codigo, exp_mensagem ");
                buf.append("from examesprincipios ");
                buf.append("where fil_codigo = ");
                buf.append(filial);
                buf.append(" and exa_codigo = '");
                buf.append(rs2.getString("exa_codigo"));
                buf.append("' and mco_codigo = ");
                buf.append(rs2.getString("mco_codigo"));
                ResultSet rs3 = Conexao.executeQuery(st3, buf.toString());
                if (rs3.next()) {
                    retorno.append("<principios>");
                    do {
                        retorno.append("<principio><codigoexame>");
                        retorno.append(rs3.getString("exa_codigo"));
                        retorno.append("</codigoexame><codigomaterial>");
                        retorno.append(rs3.getString("mco_codigo"));
                        retorno.append("</codigomaterial><codigoprincipio>");
                        retorno.append(rs3.getString("prc_codigo"));
                        retorno.append("</codigoprincipio><mensagem>");
                        retorno.append(rs3.getString("exp_mensagem"));
                        retorno.append("</mensagem></principio>");
                    } while (rs3.next());
                    retorno.append("</principios>");
                }
                retorno.append("</material>");
            }
            retorno.append("</materiais>");
            retorno.append("</exame>");
        }
        Conexao.fecharStatement(st3);
        Conexao.fecharStatement(st2);
        Conexao.fecharStatement(st);
        return retorno.toString();
    }

    @Override
    public String getMedicos(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder("<medicos>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo medicos para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select med_nome, med_conselho, med_crm, med_uf ");
            bui.append("from medico where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("medico", new Registro(rs), new String[]{"med_conselho", "med_crm", "med_uf"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "medico"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</medicos>").toString();
    }

    @Override
    public String getCidades(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder("<cidades>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo cidades para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select cid_codigo, cid_nome, cid_uf from cidades where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("cidade", new Registro(rs), new String[]{"cid_codigo"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "cidade"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</cidades>").toString();
    }

    private String getOperacao(Statement st, Statement st2, String filial, String convenio, String tabela) throws SQLException {
        this.escreverLog("Buscando novas atualizacoes para o convenio " + convenio + " na filial " + filial + " na tabela " + tabela);
        StringBuilder bui = new StringBuilder();
        StringBuilder buf = new StringBuilder();
        bui.append("select epa_codigo, epa_operacao from exportaapoio where fil_codigo = ");
        bui.append(filial);
        bui.append(" and con_codigo = ");
        bui.append(convenio);
        bui.append(" and epa_tabela = '");
        bui.append(tabela);
        bui.append("' and (epa_exportado = false or epa_exportado is null) order by epa_codigo ");
        this.escreverLog("sql: " + bui.toString());
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        bui.delete(0, bui.length());
        while (rs.next()) {
            buf.delete(0, buf.length());
            buf.append("update exportaapoio set epa_exportado = true where fil_codigo = ");
            buf.append(filial);
            buf.append(" and epa_codigo = ");
            buf.append(rs.getString("epa_codigo"));
            Conexao.executeUpdate(filial, st2, buf.toString(), true);
            buf.delete(0, buf.length());
            buf.append("delete from exportaapoio where fil_codigo = ").append(filial);
            buf.append(" and con_codigo = ").append(convenio);
            buf.append(" and epa_datahora < current_date - 60 and epa_exportado = true ");
            Conexao.executeUpdate(filial, st2, buf.toString(), true);
            this.escreverLog("op: " + rs.getString("epa_operacao"));
            bui.append(rs.getString("epa_operacao"));
        }
        return bui.toString();
    }

    @Override
    public String getBairros(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder("<bairros>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo bairros para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select bai_codigo, bai_descricao from bairro where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("bairro", new Registro(rs), new String[]{"bai_codigo"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "bairro"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</bairros>").toString();
    }

    @Override
    public String getMedicamentos(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder("<medicamentos>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo medicamentos para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select mto_codigo, mto_descricao, mto_fabricante, mto_indicacao, mto_interacao ");
            bui.append("from medicamentos where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("medicamento", new Registro(rs), new String[]{"mto_codigo"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "medicamentos"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</medicamentos>").toString();
    }

    @Override
    public String getRecipientes(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder("<recipientes>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo recipientes para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select rec_codigo, rec_descricao, rec_tipo, rec_capacidade, unm_codigo ");
            bui.append("from recipientes where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("recipiente", new Registro(rs), new String[]{"rec_codigo"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "recipientes"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</recipientes>").toString();
    }

    @Override
    public String getMensagens(String codigoFilial, String codigoConvenio) throws RemoteException, SQLException {
        if (codigoFilial == null || codigoConvenio == null) {
            this.escreverLog("Erro ao recuperar mensagens para o convenio " + codigoConvenio + " na filial " + codigoFilial);
            return "<mensagens></mensagens>";
        }
        this.escreverLog("Obtendo mensagens para o convenio " + codigoConvenio + " na filial " + codigoFilial);
        StringBuilder retorno = new StringBuilder("<mensagens>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder bui = new StringBuilder("select cme_codigo, cme_data, ");
        bui.append("cme_mensagem, cme_titulo from conveniomensagem where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and con_codigo = ");
        bui.append(codigoConvenio);
        bui.append(" and cme_exportado = false order by cme_codigo");
        try {
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append("<mensagem>");
                retorno.append("<dataMensagem>");
                retorno.append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", rs.getTimestamp("cme_data")));
                retorno.append("</dataMensagem>");
                retorno.append("<tituloMensagem>");
                retorno.append(rs.getString("cme_titulo"));
                retorno.append("</tituloMensagem>");
                retorno.append("<textoMensagem>");
                retorno.append(rs.getString("cme_mensagem"));
                retorno.append("</textoMensagem>");
                retorno.append("</mensagem>");
                bui.delete(0, bui.length());
                bui.append("update conveniomensagem set cme_exportado = true where fil_codigo = ");
                bui.append(codigoFilial);
                bui.append(" and cme_codigo = ");
                bui.append(rs.getString("cme_codigo"));
                bui.append(" and con_codigo = ");
                bui.append(codigoConvenio);
                Conexao.executeUpdate(codigoFilial, st2, bui.toString(), true);
            }
            retorno.append("</mensagens");
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.escreverLog(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st2);
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st2);
        Conexao.fecharStatement(st);
        return retorno.toString();
    }

    @Override
    public String enviarPaciente(String codigoFilial, String codigoConvenio, String paciente) throws RemoteException, SQLException {
        if (Funcoes.textoVazio(codigoConvenio) || Funcoes.textoVazio(paciente)) {
            this.escreverLog("Erro ao receber paciente no convenio " + codigoConvenio + " na filial " + codigoFilial);
            return "";
        }
        String retorno = "<resultado><status>2</status></resultado>";
        this.escreverLog("Recebendo paciente para o convenio " + codigoConvenio + " na filial " + codigoFilial);
        Statement st = Conexao.getStatement();
        try {
            String codigo = Util.getCodigoXML(paciente, "ple_codigo");
            this.escreverLog("Recuperando o c\u00f3digo do paciente " + codigo + " convenio " + codigoConvenio + " na filial " + codigoFilial);
            if (Funcoes.textoVazio(codigo) || DBUtil.campoNull(codigo)) {
                String[] comando = Util.geraInsertPaciente(paciente, codigoFilial, codigoConvenio);
                this.escreverLog("sql: " + comando[0]);
                if (!Funcoes.textoVazio(comando[0])) {
                    this.escreverLog("sql: " + comando[0]);
                    Conexao.executeUpdate(codigoFilial, st, comando[0], true);
                    Util.gravaAutoCopiaPaciente(codigoFilial, comando[1], comando[2], true);
                    Util.exportaWebPaciente(codigoFilial, comando[1], true);
                    StringBuilder buf = new StringBuilder();
                    buf.append("<resultado><status>1</status><codigoapoio>");
                    buf.append(comando[1]);
                    buf.append("</codigoapoio></resultado>");
                    retorno = buf.toString();
                }
            } else {
                String sql = "select pac_codigo from paciente where fil_codigo = " + codigoFilial + " and con_codigo = " + codigoConvenio + " and pac_codigo = " + codigo;
                ResultSet rs = Conexao.executeQuery(st, sql);
                if (rs.next()) {
                    String comando = Util.geraUpdatePaciente(paciente, codigoFilial, codigoConvenio);
                    if (!Funcoes.textoVazio(comando)) {
                        Conexao.executeUpdate(codigoFilial, st, comando, true);
                        Util.gravaAutoCopiaPaciente(codigoFilial, codigo, codigo, false);
                        Util.exportaWebPaciente(codigoFilial, codigo, false);
                    }
                    retorno = "<resultado><status>1</status></resultado>";
                } else {
                    String[] comando = Util.geraInsertPaciente(paciente, codigoFilial, codigoConvenio);
                    if (!Funcoes.textoVazio(comando[0])) {
                        this.escreverLog("sql: " + comando[0]);
                        Conexao.executeUpdate(codigoFilial, st, comando[0], true);
                        Util.gravaAutoCopiaPaciente(codigoFilial, comando[1], comando[2], true);
                        Util.exportaWebPaciente(codigoFilial, comando[1], true);
                        StringBuilder buf = new StringBuilder();
                        buf.append("<resultado><status>1</status><codigoapoio>");
                        buf.append(comando[1]);
                        buf.append("</codigoapoio></resultado>");
                        retorno = buf.toString();
                    }
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            retorno = "<resultado><status>0</status></resultado>";
            try {
                Conexao.anulaSQL();
                ex.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    @Override
    public String criarLote(String codigoFilial, String codigoConvenio, String lote) throws RemoteException, SQLException {
        boolean semEtiquetas = false;
        StringBuilder retorno = new StringBuilder("<lote>0</lote>");
        StringBuilder codigoRequisicoes = new StringBuilder();
        if (Funcoes.textoVazio(lote)) {
            this.escreverLog("Erro ao receber lote do convenio " + codigoConvenio + " na filial " + codigoFilial + " - Lote vazio");
            return retorno.toString();
        }
        String codigoLote = StringUtil.getValor(lote, "lot_codigo");
        String dataLote = StringUtil.getValor(lote, "lot_data");
        String[] requisicoes = StringUtil.getValores(StringUtil.getValor(lote, "requisicoes"), "requisicao", true);
        if (requisicoes.length == 0) {
            this.escreverLog("Erro ao receber lote do convenio " + codigoConvenio + " na filial " + codigoFilial + " - Nenhuma requisicao localizada");
            return retorno.toString();
        }
        this.escreverLog("Recebendo " + requisicoes.length + " requisicoes do convenio " + codigoConvenio + " na filial " + codigoFilial + " no lote " + codigoLote);
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select con_apoiosemetiqueta from convenios where fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and con_codigo = ");
            buf.append(codigoConvenio);
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            semEtiquetas = rs.next() && rs.getBoolean("con_apoiosemetiqueta");
            buf.delete(0, buf.length());
            buf.append("select lot_codigo from loteapoio where fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and con_codigo = ");
            buf.append(codigoConvenio);
            buf.append(" and lot_codigo = ");
            buf.append(codigoLote);
            rs = Conexao.executeQuery(st, buf.toString());
            String sequencia = "";
            if (!rs.next()) {
                sequencia = DBUtil.getSequencia(st, "loteapoio", codigoFilial);
                buf.delete(0, buf.length());
                buf.append("insert into loteapoio(fil_codigo, lot_id, con_codigo, lot_codigo, lot_datahora) values (");
                buf.append(codigoFilial);
                buf.append(", ");
                buf.append(sequencia).append(", ");
                buf.append(codigoConvenio);
                buf.append(", ");
                buf.append(codigoLote);
                buf.append(", '");
                buf.append(dataLote);
                buf.append("')");
                this.escreverLog("sql: " + buf.toString());
                Conexao.executeUpdate(codigoFilial, st, buf.toString(), true);
            }
            retorno.delete(0, retorno.length());
            retorno.append("<lote><status>1</status><etiquetas>");
            for (String s : requisicoes) {
                String[] exames = StringUtil.getValores(StringUtil.getValor(s, "exames"), "examerequisicao", true);
                s = StringUtil.removerTagsXML(s, "exames");
                String[] medicamentos = StringUtil.getValores(StringUtil.getValor(s, "medicamentos"), "medicamento", true);
                String[] comando = Util.geraInsertRequisicao(s = StringUtil.removerTagsXML(s, "medicamentos"), codigoFilial, codigoConvenio);
                if (!Funcoes.textoVazio(comando[0])) {
                    this.escreverLog(comando[0]);
                    Conexao.executeUpdate(codigoFilial, st, comando[0], true);
                }
                StringBuilder bui = new StringBuilder();
                bui.append("select a.req_codigo from loteapoiorequisicao a ");
                bui.append("left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id ");
                bui.append("where b.fil_codigo = ").append(codigoFilial);
                bui.append(" and b.con_codigo = ").append(codigoConvenio);
                bui.append(" and b.lot_codigo = ").append(codigoLote);
                bui.append(" and a.req_codigo = ").append(comando[1]);
                if (!Conexao.executeQuery(st, bui.toString()).next() && !Funcoes.textoVazio(sequencia)) {
                    bui.setLength(0);
                    bui.append("insert into loteapoiorequisicao(fil_codigo, lot_id, req_codigo) values (");
                    bui.append(codigoFilial);
                    bui.append(", ").append(sequencia).append(", ");
                    bui.append(comando[1]);
                    bui.append(")");
                    this.escreverLog("sql: " + bui.toString());
                    Conexao.executeUpdate(codigoFilial, st, bui.toString(), true);
                }
                for (String medicamento : medicamentos) {
                    Conexao.executeUpdate(codigoFilial, st, Util.geraInsertRequisicaoMedicamento(medicamento, codigoFilial, comando[1]), true);
                }
                for (String exame : exames) {
                    String c = Util.geraInsertExameRequisicao(exame, codigoFilial, codigoConvenio, comando[1]);
                    this.escreverLog(c);
                    Conexao.executeUpdate(codigoFilial, st, c, true);
                }
                bui.delete(0, bui.length());
                bui.append("select sum(exr_vlrexame) as soma from examerequisicao ");
                bui.append(" where fil_codigo = ").append(codigoFilial);
                bui.append(" and req_codigo = ").append(comando[1]);
                rs = Conexao.executeQuery(st, bui.toString());
                double valor = 0.0;
                if (rs.next()) {
                    valor = rs.getDouble("soma");
                }
                rs.close();
                bui.delete(0, bui.length());
                bui.append("update requisicao set req_total = ").append(Funcoes.limpaDecimal(String.valueOf(valor)));
                bui.append(" where fil_codigo = ").append(codigoFilial);
                bui.append(" and req_codigo = ").append(comando[1]);
                Conexao.executeUpdate(codigoFilial, st, bui.toString(), true);
                for (String exame : exames) {
                    String codigoExame = Util.getCodigoXML(exame, "exa_codigo");
                    String codigoMaterial = Util.getCodigoXML(exame, "mco_codigo");
                    if (Funcoes.textoVazio(codigoExame) || !Funcoes.isNumeric(codigoMaterial)) continue;
                    ExportaFiliais.gravaRequisicao(Integer.parseInt(codigoFilial), Integer.parseInt(comando[1]), codigoExame, Integer.parseInt(codigoMaterial), "I", "I");
                }
                Util.exportaWebRequisicao(codigoFilial, comando[1], true);
                String etiquetas = Impressao.getEtiquetaColetaApoio(codigoFilial, comando[1], false);
                if (!semEtiquetas) {
                    retorno.append(StringUtil.textoXML(etiquetas));
                }
                codigoRequisicoes.append("<requisicao><codigo>");
                codigoRequisicoes.append(Util.getCodigoXML(s, "req_codigo"));
                codigoRequisicoes.append("</codigo><novocodigo>");
                codigoRequisicoes.append(comando[1]);
                codigoRequisicoes.append("</novocodigo></requisicao>");
            }
            retorno.append("</etiquetas><requisicoes>");
            retorno.append(codigoRequisicoes.toString());
            retorno.append("</requisicoes></lote>");
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ex.printStackTrace();
            this.escreverLog(ex.getMessage());
            retorno.delete(0, retorno.length());
            retorno.append("<requisicao><status>2</status><mensagemerro>").append(ex.getMessage()).append("</mensagemerro></requisicao>");
        }
        return retorno.toString();
    }

    @Override
    public String getFeriados(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws SQLException, RemoteException {
        StringBuilder retorno = new StringBuilder("<feriados>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo feriados para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select fer_dia, fer_motivo, fer_fixo ");
            bui.append("from feriados where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("feriado", new Registro(rs), new String[]{"fer_dia"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "feriados"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</feriados>").toString();
    }

    @Override
    public String getMaterialColeta(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws SQLException, RemoteException {
        StringBuilder retorno = new StringBuilder("<materiaiscoleta>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo materiais de coleta para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select mco_codigo, mco_descricao, mco_abreviatura, mco_solicitarmat ");
            bui.append("from materialcoleta where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("materialcoleta", new Registro(rs), new String[]{"mco_codigo"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "materialcoleta"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</materiaiscoleta>").toString();
    }

    @Override
    public String getMetodos(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws SQLException, RemoteException {
        StringBuilder retorno = new StringBuilder("<metodologias>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo metodos para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select met_codigo, met_descricao ");
            bui.append("from metodologia where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("metodologia", new Registro(rs), new String[]{"met_codigo"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "metodologia"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</metodologias>").toString();
    }

    @Override
    public String getPrazoEntrega(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws SQLException, RemoteException {
        StringBuilder retorno = new StringBuilder("<prazosentrega>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo prazos de entrega para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select prz_codigo, prz_descricao, prz_prazo, prz_dias, prz_horaentrada, prz_horasaida ");
            bui.append("from prazoentrega where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("prazoentrega", new Registro(rs), new String[]{"prz_codigo"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "prazoentrega"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</prazosentrega>").toString();
    }

    @Override
    public String getSetores(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws SQLException, RemoteException {
        StringBuilder retorno = new StringBuilder("<setores>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo setores para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        if (primeiraConexao) {
            bui.append("select set_codigo, set_descricao, set_responsavel, set_cor, set_sigla ");
            bui.append("from setores where fil_codigo = ");
            bui.append(codigoFilial);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append(XMLUtil.criaXML("setor", new Registro(rs), new String[]{"set_codigo"}));
            }
        } else {
            try {
                retorno.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "setores"));
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</setores>").toString();
    }

    @Override
    public String getCodigoCliente() throws SQLException, RemoteException {
        this.escreverLog("Obtendo codigo do cliente para nova conexao");
        return String.valueOf(ParametrosGerais.getCodigoCliente());
    }

    @Override
    public String getParametrosGerais() throws SQLException, RemoteException {
        this.escreverLog("Obtendo parametros gerais para cliente");
        StringBuilder bui = new StringBuilder("<parametros>");
        bui.append("<uppercase>");
        bui.append(ParametrosGerais.getUpperCase() ? TRUE : FALSE);
        bui.append("</uppercase>");
        bui.append("<ordenarsetor>");
        bui.append(ParametrosGerais.getOrdenarSetor() ? TRUE : FALSE);
        bui.append("</ordenarsetor>");
        bui.append("<conferencia>");
        bui.append(ParametrosGerais.getConferencia() ? TRUE : FALSE);
        bui.append("</conferencia>");
        bui.append("<mascara>");
        bui.append(ParametrosGerais.getMascaraFone());
        bui.append("</mascara>");
        bui.append("<layout>");
        bui.append(ParametrosGerais.getLayCodigo());
        bui.append("</layout>");
        bui.append("<obrigadosabem>");
        bui.append(ParametrosGerais.getObrigaDosagem());
        bui.append("</obrigadosagem>");
        bui.append("<buscacpf>");
        bui.append(ParametrosGerais.getBuscaCPF());
        bui.append("</buscacpf>");
        return bui.append("</parametros>").toString();
    }

    @Override
    public String getPaciente(String codigoFilial, String codigoConvenio) throws SQLException, RemoteException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo pacientes para o convenio " + codigoConvenio + " na filial " + codigoFilial);
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "paciente"));
            String[] pacientes = StringUtil.getValores(buf.toString(), "paciente");
            buf.delete(0, buf.length());
            buf.append("select pac_codigo, bai_codigo, pac_nome, pac_sexo, ");
            buf.append("pac_datanasc, pac_vip, pac_grpsangue, pac_fatorrh, pac_fatordu, ");
            buf.append("pac_cor, pac_observ, pac_dadoclinico, pac_peso, pac_altura, ");
            buf.append("pac_matricconv, pac_titularconv, pac_profissao, pac_fumante, ");
            buf.append("pac_diabetico, pac_rg, pac_cpf, pac_estcivil, pac_numfilho, ");
            buf.append("pac_dum, cid_codigo, pac_fax, pac_celular, ");
            buf.append("pac_fonecomercial, pac_fone, pac_cep, pac_complemento, ");
            buf.append("pac_endereco, pac_numeroendereco, pac_tipologradouroendereco, pac_email, pac_anomes, pac_idade, con_codigo, ");
            buf.append("med_conselho, med_crm, med_uf, pac_fonecontato, pac_nomecontato, ");
            buf.append("pac_mae, pac_pai, pac_maladireta, pac_senhaweb, pac_codigoapoiado ");
            buf.append("from paciente ");
            buf.append("where fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and pac_codigo = ?");
            PreparedStatement pst = Conexao.getPreparedStatement(buf.toString());
            buf.delete(0, buf.length());
            for (String s : pacientes) {
                Registro reg;
                String codigo = StringUtil.getValor(s, "codigo");
                if (!Funcoes.isNumeric(codigo)) continue;
                pst.setLong(1, Long.parseLong(codigo));
                ResultSet rs = Conexao.executeQuery(pst);
                if (!rs.next()) continue;
                reg.setValor("pac_fumante", !(reg = new Registro(rs)).nulo("pac_fumante") && reg.getString("pac_fumante").equalsIgnoreCase("S"));
                reg.setValor("pac_diabetico", !reg.nulo("pac_diabetico") && reg.getString("pac_diabetico").equalsIgnoreCase("S"));
                buf.append(XMLUtil.criaXML("paciente", new Registro(rs), new String[]{"pac_codigo"}));
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return buf.toString();
    }

    @Override
    public String getRequisicao(String codigoFilial, String codigoConvenio) throws SQLException, RemoteException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo informacoes de requisicao para o convenio " + codigoConvenio + " na filial " + codigoFilial);
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "requisicao"));
            String[] pacientes = StringUtil.getValores(buf.toString(), "requisicao");
            buf.delete(0, buf.length());
            buf.append("select a.req_codigoapoiado as req_codigo, a.sit_codigo, a.med_conselho, a.med_crm, ");
            buf.append("a.req_data, ");
            buf.append("a.req_dtfatura, a.req_urgente, a.req_dataentregaprev, a.req_dclinicos, a.req_obs, ");
            buf.append("a.req_totpago, a.req_total, a.med_uf, a.req_horaentregaprev, a.req_horafatura, a.req_hora, ");
            buf.append("a.req_gestante, a.req_dum, a.req_anomes, a.req_idade, a.req_avisarpaciente, ");
            buf.append("a.req_titular, a.req_altura, a.req_peso, ");
            buf.append("a.req_datarequisicao, a.req_neonato ");
            buf.append("from requisicao a ");
            buf.append("where fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and req_codigo = ?");
            buf.append(" and req_excluida = false ");
            PreparedStatement pst = Conexao.getPreparedStatement(buf.toString());
            buf.delete(0, buf.length());
            for (String s : pacientes) {
                String codigo = StringUtil.getValor(s, "codigo");
                if (!Funcoes.isNumeric(codigo)) continue;
                pst.setInt(1, Integer.parseInt(codigo));
                ResultSet rs = Conexao.executeQuery(pst);
                if (!rs.next()) continue;
                buf.append(XMLUtil.criaXML("requisicao", new Registro(rs), new String[]{"req_codigo"}));
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return buf.toString();
    }

    @Override
    public String getExameRequisicao(String codigoFilial, String codigoConvenio) throws SQLException, RemoteException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo situacao/resultados de exames para o convenio " + codigoConvenio + " na filial " + codigoFilial);
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "examerequisicao"));
            this.escreverLog("opera\u00e7\u00e3o: " + buf.toString());
            String[] exames = StringUtil.getValores(buf.toString(), "examerequisicao");
            buf.delete(0, buf.length());
            buf.append("select b.req_codigoapoiado as req_codigo, a.exr_situacao,  ");
            buf.append("a.exr_datamaterial, a.exr_datadigita, a.exr_dataassina, ");
            buf.append("a.exr_dataentregaprev, ");
            buf.append("a.exr_resposta, a.met_codigo, a.usr_codassina, ");
            buf.append("a.exa_codigo, a.mco_codigo, ");
            buf.append("a.exr_descricaomaterial, ");
            buf.append("a.exr_obs, a.exr_datacortesia, a.usr_codcortesia, ");
            buf.append("a.exr_data, CASE WHEN a.exr_intervaloJejum is null then TO_CHAR(a.exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(a.exr_intervaloJejum,'HH24:MI:SS') end as exr_intervalojejum, ");
            buf.append("a.exr_codexameorigem, a.exr_codmatorigem ");
            buf.append("from examerequisicao a ");
            buf.append("left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and a.req_codigo = ?");
            buf.append(" and a.exa_codigo = ?");
            buf.append(" and a.mco_codigo = ?");
            buf.append(" and a.exr_excluido = false ");
            buf.append(" and b.req_excluida = false ");
            PreparedStatement pst = Conexao.getPreparedStatement(buf.toString());
            this.escreverLog("prst: " + buf.toString());
            buf.delete(0, buf.length());
            for (String s : exames) {
                String codigo = StringUtil.getValor(s, "codigo");
                String exame = StringUtil.getValor(s, "exame");
                String material = StringUtil.getValor(s, "material");
                String operacao = StringUtil.getValor(s, "operacao");
                this.escreverLog(codigo + ", " + exame + ", " + material + ", " + operacao);
                if (!Funcoes.isNumeric(codigo) || !Funcoes.isNumeric(material)) continue;
                pst.setInt(1, Integer.parseInt(codigo));
                pst.setString(2, exame);
                pst.setInt(3, Integer.parseInt(material));
                ResultSet rs = Conexao.executeQuery(pst);
                if (!Funcoes.textoVazio(operacao) && operacao.equalsIgnoreCase("D")) {
                    StringBuilder bui = new StringBuilder();
                    bui.append("select req_codigoapoiado from requisicao where fil_codigo = ");
                    bui.append(codigoFilial);
                    bui.append(" and req_codigo = ");
                    bui.append(codigo);
                    ResultSet rDelete = Conexao.executeQuery(st2, bui.toString());
                    if (!rDelete.next()) continue;
                    buf.append("<examerequisicao><comando>delete from examerequisicao where req_codigo = ");
                    buf.append(rDelete.getString("req_codigoapoiado"));
                    buf.append(" and exa_codigo = '");
                    buf.append(exame);
                    buf.append("' and mco_codigo = ");
                    buf.append(material);
                    buf.append("</comando></examerequisicao>");
                    continue;
                }
                if (!rs.next()) continue;
                buf.append(XMLUtil.criaXML("examerequisicao", new Registro(rs), new String[]{"req_codigo", "exa_codigo", "mco_codigo"}));
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return buf.toString();
    }

    @Override
    public String getResultados(String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws SQLException, RemoteException {
        Statement st = Conexao.getStatement();
        this.escreverLog("Obtendo resultados de exames para a filial " + codigoFilial + " na requisicao " + codigoRequisicao + " e o exame " + codigoExame);
        StringBuilder buf = new StringBuilder();
        try {
            buf.delete(0, buf.length());
            buf.append("select b.req_codigoapoiado as req_codigo, a.exr_situacao, a.exa_codigo, a.mco_codigo, ");
            buf.append("pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado  ");
            buf.append("from examerequisicao a ");
            buf.append("left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" and a.req_codigo = ?");
            buf.append(" and a.exa_codigo = ?");
            buf.append(" and a.mco_codigo = ?");
            buf.append(" and a.exr_excluido = false ");
            buf.append(" and b.req_excluida = false ");
            PreparedStatement pst = Conexao.getPreparedStatement(buf.toString());
            String codigo = codigoRequisicao;
            String exame = codigoExame;
            String material = codigoMaterial;
            buf.setLength(0);
            pst.setInt(1, Integer.parseInt(codigo));
            pst.setString(2, exame);
            pst.setInt(3, Integer.parseInt(material));
            ResultSet rs = Conexao.executeQuery(pst);
            if (rs.next() && (this.enviarParcial || !this.enviarParcial && !rs.getString("exr_situacao").equals("P"))) {
                buf.append("<resultados><resultado>");
                buf.append(StringUtil.compactar(rs.getString("exr_resultado")));
                buf.append("</resultado><situacao>");
                buf.append(rs.getString("exr_situacao")).append("</situacao>");
                buf.append("<considerarparcial>").append(this.enviarParcial ? "sim" : "nao").append("</considerarparcial>");
                buf.append("</resultados>");
            }
        }
        catch (Exception ex) {
            buf.delete(0, buf.length());
            buf.append("<resultado></resultado>");
            ex.printStackTrace();
        }
        Conexao.fecharStatement(st);
        return buf.toString();
    }

    @Override
    public String getLayout(String codigoFilial, String codigoConvenio) throws SQLException, RemoteException {
        StringBuilder retorno = new StringBuilder("<layouts>");
        Statement st = Conexao.getStatement();
        this.escreverLog("Obtendo modelos para o convenio " + codigoConvenio + " na filial " + codigoFilial);
        StringBuilder bui = new StringBuilder();
        bui.append("select a.lay_codigo, b.lay_cabec, a.lay_codigoapoio, c.lay_cabec as lay_cabecapoio, a.con_apoiomudamodelo from convenios a ");
        bui.append("left join layout b on a.fil_codigo = b.fil_codigo and a.lay_codigo = b.lay_codigo ");
        bui.append("left join layout c on a.fil_codigo = c.fil_codigo and a.lay_codigoapoio = c.lay_codigo ");
        bui.append(" where a.fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and a.con_codigo = ");
        bui.append(codigoConvenio);
        try {
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                retorno.append("<codigo>");
                retorno.append(!DBUtil.campoNull(rs.getString("lay_codigoapoio")) ? rs.getInt("lay_codigoapoio") : rs.getInt("lay_codigo"));
                retorno.append("</codigo><layout>");
                retorno.append(StringUtil.compactar(!DBUtil.campoNull(rs.getString("lay_codigoapoio")) ? rs.getString("lay_cabecapoio") : rs.getString("lay_cabec")));
                retorno.append("</layout>");
                retorno.append(StringUtil.getTag("permissao", rs.getString("con_apoiomudamodelo")));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Conexao.fecharStatement(st);
        return retorno.append("</layouts>").toString();
    }

    @Override
    public String getUsuarios() throws SQLException, RemoteException {
        StringBuilder retorno = new StringBuilder("<usuarios>");
        Statement st = Conexao.getStatement();
        this.escreverLog("Obtendo usuarios");
        StringBuilder bui = new StringBuilder();
        bui.append("select usr_codigo, usr_nome, usr_assinatura from usuario where usr_assinatura <> ''");
        try {
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                retorno.append("<usuario><usr_codigo>");
                retorno.append(rs.getString("usr_codigo"));
                retorno.append("</usr_codigo><usr_nome>");
                retorno.append(rs.getString("usr_nome"));
                retorno.append("</usr_nome></usuario>");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Conexao.fecharStatement(st);
        return retorno.append("</usuarios>").toString();
    }

    @Override
    public String getAssinatura(String usuario) throws SQLException, RemoteException {
        StringBuilder retorno = new StringBuilder("<usuario>");
        Statement st = Conexao.getStatement();
        this.escreverLog("Obtendo usuario especifico");
        StringBuilder bui = new StringBuilder();
        bui.append("select usr_assinatura from usuario where usr_codigo = '");
        bui.append(StringUtil.textoDB(usuario));
        bui.append("'");
        try {
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                retorno.append("<usr_assinatura>");
                retorno.append(StringUtil.compactar(rs.getString("usr_assinatura")));
                retorno.append("</usr_assinatura>");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Conexao.fecharStatement(st);
        return retorno.append("</usuario>").toString();
    }

    @Override
    public String getEtiquetas(String codigoFilial, String codigoConvenio, String codigoLote) throws SQLException, RemoteException {
        StringBuilder buf = new StringBuilder("<etiquetas>");
        StringBuilder bui = new StringBuilder("select con_apoiosemetiqueta from convenios where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and con_codigo = ");
        bui.append(codigoConvenio);
        this.escreverLog("Obtendo etiquetas para o convenio " + codigoConvenio + " na filial " + codigoFilial + " para o lote " + codigoLote);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        boolean semEtiquetas = rs.next() && rs.getBoolean("con_apoiosemetiqueta");
        bui.delete(0, bui.length());
        bui.append("select a.req_codigo from loteapoiorequisicao a ");
        bui.append("left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id ");
        bui.append("where b.fil_codigo = ").append(codigoFilial);
        bui.append(" and b.con_codigo = ").append(codigoConvenio);
        bui.append(" and b.lot_codigo = ").append(codigoLote);
        rs = Conexao.executeQuery(st, bui.toString());
        try {
            while (rs.next()) {
                if (!semEtiquetas) {
                    buf.append(Impressao.getEtiquetaColetaApoio(codigoFilial, rs.getString("req_codigo")));
                    continue;
                }
                Impressao.getEtiquetaColetaApoio(codigoFilial, rs.getString("req_codigo"));
            }
        }
        catch (Exception ex) {
            buf.delete(0, buf.length());
            buf.append("<etiquetas><status>2</status>");
        }
        buf.append("</etiquetas>");
        return buf.toString();
    }

    @Override
    public String getModeloRelatorio() throws SQLException, RemoteException {
        StringBuilder buf = new StringBuilder("<relatorio>");
        StringBuilder bui = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
        bui.append(RelatorioConferenciaEnviados.getModuloAcesso());
        this.escreverLog("Obtendo modelo do relatorio");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        try {
            while (rs.next()) {
                buf.append(StringUtil.textoXML(rs.getString("rel_xml")));
            }
        }
        catch (Exception ex) {
            buf.delete(0, buf.length());
            buf.append("<relatorio><status>2</status>");
        }
        buf.append("</relatorio>");
        return buf.toString();
    }

    @Override
    public String getMaiorCodigoRequisicao(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder("<maiorcodigo>");
        Statement st = Conexao.getStatement();
        this.escreverLog("Obtendo maior codigo de requisicao para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder bui = new StringBuilder();
        bui.append("select max(req_codigoapoiado) as maximo from requisicao where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and con_codigo = ");
        bui.append(codigoConvenio);
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next() && Funcoes.isNumeric(rs.getString("maximo"))) {
            retorno.append(rs.getInt("maximo"));
        } else {
            retorno.append("0");
        }
        Conexao.fecharStatement(st);
        return retorno.append("</maiorcodigo>").toString();
    }

    @Override
    public String getMaiorCodigoLote(String codigoFilial, String codigoConvenio) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder("<maiorcodigo>");
        Statement st = Conexao.getStatement();
        this.escreverLog("Obtendo maior codigo de lote para o convenio " + codigoConvenio + " na filial " + codigoFilial);
        StringBuilder bui = new StringBuilder();
        bui.append("select max(lot_codigo) as maximo from loteapoio where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and con_codigo = ");
        bui.append(codigoConvenio);
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            retorno.append(rs.getInt("maximo"));
        } else {
            retorno.append("0");
        }
        Conexao.fecharStatement(st);
        return retorno.append("</maiorcodigo>").toString();
    }

    @Override
    public String getExames(String codigoFilial, String codigoConvenio, String[] exames) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder("<exames>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        for (String s : exames) {
            retorno.append(this.xmlExame(codigoFilial, codigoConvenio, s));
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</exames>").toString();
    }

    private String geraTagExclusao(String exame, String material) {
        StringBuilder buf = new StringBuilder();
        buf.append("<excluir>");
        buf.append("<codigo>").append(exame).append("</codigo>");
        if (!Funcoes.textoVazio(material)) {
            buf.append("<material>").append(material).append("</material>");
        }
        buf.append("</excluir>");
        return buf.toString();
    }

    @Override
    public String getListagemExames(String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws RemoteException, SQLException {
        StringBuilder retorno = new StringBuilder("<listagemexames>");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.escreverLog("Obtendo listagem de exames para o convenio " + codigoConvenio + " na filial " + codigoFilial + (primeiraConexao ? " - Primeira conexao" : ""));
        StringBuilder buf = new StringBuilder();
        ArrayList<String> exames = new ArrayList<String>();
        ArrayList<String> paraExcluir = new ArrayList<String>();
        if (primeiraConexao) {
            buf.append("select a.exa_codigo, count(c.exa_codigo) as total ");
            buf.append("from exames a ");
            buf.append("left join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" group by a.exa_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                buf.setLength(0);
                buf.append("select a.exa_codigo, count(b.exa_codigo) as proibidos ");
                buf.append("from exames a ");
                buf.append("left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and b.emc_proibidoapoio = true ");
                buf.append("where a.fil_codigo = ");
                buf.append(codigoFilial);
                buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(rs.getString("exa_codigo"))).append("' ");
                buf.append(" group by a.exa_codigo ");
                ResultSet rs2 = Conexao.executeQuery(st2, buf);
                int proibidos = 0;
                if (rs2.next()) {
                    proibidos = rs2.getInt("proibidos");
                }
                rs2.close();
                if (proibidos == rs.getInt("total")) {
                    paraExcluir.add(this.geraTagExclusao(rs.getString("exa_codigo"), ""));
                    continue;
                }
                if (proibidos == rs.getInt("total")) continue;
                if (proibidos > 0) {
                    buf.delete(0, buf.length());
                    buf.append("select exa_codigo, mco_codigo from examematcoleta where fil_codigo = ");
                    buf.append(codigoFilial);
                    buf.append(" and exa_codigo = '").append(StringUtil.textoDB(rs.getString("exa_codigo"))).append("'");
                    buf.append(" and emc_proibidoapoio = true ");
                    ResultSet rsTemp = Conexao.executeQuery(st2, buf);
                    while (rsTemp.next()) {
                        paraExcluir.add(this.geraTagExclusao(rs.getString("exa_codigo"), rsTemp.getString("mco_codigo")));
                    }
                }
                exames.add(rs.getString("exa_codigo"));
            }
        } else {
            try {
                buf.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "exames"));
                String[] lista = StringUtil.getValores(buf.toString(), "exame");
                for (String s : lista) {
                    buf.delete(0, buf.length());
                    String temp = StringUtil.getValor(s, "codigo");
                    String operacao = StringUtil.getValor(s, "operacao");
                    String material = StringUtil.getValor(s, "material");
                    if (Funcoes.textoVazio(temp)) continue;
                    if (!Funcoes.textoVazio(operacao)) {
                        paraExcluir.add(this.geraTagExclusao(temp, material));
                        continue;
                    }
                    exames.add(temp);
                }
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception rs2) {
                    // empty catch block
                }
                ex.printStackTrace();
                exames.clear();
            }
        }
        for (String s : exames) {
            retorno.append(StringUtil.getTag("exame", s));
        }
        if (!paraExcluir.isEmpty()) {
            retorno.append("<examesexcluir>");
            for (String s : paraExcluir) {
                retorno.append(s);
            }
            retorno.append("</examesexcluir>");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno.append("</listagemexames>").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getImagemSuporte() throws RemoteException {
        byte[] retorno = null;
        try {
            if (Funcoes.textoVazio(this.imagemSuporte)) {
                return retorno;
            }
            File f = new File(this.imagemSuporte);
            if (!f.exists()) {
                return retorno;
            }
            try (FileImageInputStream in = null;){
                in = new FileImageInputStream(f);
                retorno = new byte[(int)in.length()];
                in.read(retorno);
            }
        }
        catch (Exception e) {
            retorno = null;
        }
        return retorno;
    }
}

