/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidor;

import jalis.apoio.servidor.ServidorImpl;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.util.Funcoes;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Date;

public class Servidor {
    private static BufferedWriter log = null;
    private static String imagemSuporte = "";
    private static boolean enviarParcial = false;

    public Servidor() {
        ParametrosGerais.carregaParametros();
        this.registraServidor();
    }

    public static void main(String[] args) {
        String banco = ParametrosLocais.getParametro("caminhoBanco");
        Variaveis.login = ParametrosLocais.getParametro("usuarioPadraoRMI");
        Variaveis.codigoEstacao = ParametrosLocais.getParametro("estacaoPadraoRMI");
        int pos = -1;
        if (Funcoes.procuraArg(args, "-help") >= 0 || Funcoes.procuraArg(args, "--help") >= 0) {
            Servidor.mostrarHelp();
            return;
        }
        if (Funcoes.procuraArg(args, "-verao") >= 0) {
            Funcoes.configurarHorarioVerao(true);
        }
        if ((pos = Funcoes.procuraArg(args, "-ip")) >= 0 && args.length >= pos + 1 && Funcoes.verificaIP(args[pos + 1])) {
            ParametrosLocais.setParametro("caminhoBanco", args[pos + 1]);
            ParametrosLocais.salvaParametros();
            banco = args[pos + 1];
        } else if (banco == null) {
            System.out.println("Caminho do banco de dados n\u00e3o localizado\n utilize \n -ip [ip servidor] para atualizar o banco de dados");
            return;
        }
        pos = Funcoes.procuraArg(args, "-usuario");
        if (pos >= 0 && args.length >= pos + 1 && !Funcoes.textoVazio(args[pos + 1])) {
            ParametrosLocais.setParametro("usuarioPadraoRMI", args[pos + 1]);
            ParametrosLocais.salvaParametros();
            Variaveis.login = args[pos + 1];
        } else if (Variaveis.login == null || Funcoes.textoVazio(Variaveis.login)) {
            System.out.println("Usu\u00e1rio padr\u00e3o n\u00e3o localizado\n utilize \n -usuario [login] para atualizar o sistema com o usu\u00e1rio padr\u00e3o");
            return;
        }
        pos = Funcoes.procuraArg(args, "-estacao");
        if (pos >= 0 && args.length >= pos + 1 && Funcoes.isNumeric(args[pos + 1])) {
            ParametrosLocais.setParametro("estacaoPadraoRMI", args[pos + 1]);
            ParametrosLocais.salvaParametros();
            Variaveis.codigoEstacao = args[pos + 1];
        } else if (Variaveis.codigoEstacao == null || Funcoes.textoVazio(Variaveis.codigoEstacao)) {
            System.out.println("C\u00f3digo da esta\u00e7\u00e3o n\u00e3o informado\n utilize \n -estacao [c\u00f3digo] para atualizar o banco de dados");
            return;
        }
        pos = Funcoes.procuraArg(args, "-medicoCrm");
        if (pos >= 0 && args.length >= pos + 1 && !Funcoes.textoVazio(args[pos + 1])) {
            ParametrosLocais.setParametro("medicoCrmPadraoRMI", args[pos + 1]);
            ParametrosLocais.salvaParametros();
        } else if (ParametrosLocais.getParametro("medicoCrmPadraoRMI") == null || Funcoes.textoVazio(ParametrosLocais.getParametro("medicoCrmPadraoRMI"))) {
            System.out.println("M\u00e9dico padr\u00e3o n\u00e3o localizado\n utilize \n -medicoCrm [CRM] para atualizar o sistema com o m\u00e9dico padr\u00e3o");
            return;
        }
        pos = Funcoes.procuraArg(args, "-medicoUF");
        if (pos >= 0 && args.length >= pos + 1 && !Funcoes.textoVazio(args[pos + 1])) {
            ParametrosLocais.setParametro("medicoUFPadraoRMI", args[pos + 1]);
            ParametrosLocais.salvaParametros();
        } else if (ParametrosLocais.getParametro("medicoUFPadraoRMI") == null || Funcoes.textoVazio(ParametrosLocais.getParametro("medicoCrmPadraoRMI"))) {
            System.out.println("Estado do m\u00e9dico padr\u00e3o n\u00e3o localizado\n utilize \n -medicoUF [UF] para atualizar o sistema com o estado do m\u00e9dico padr\u00e3o");
            return;
        }
        pos = Funcoes.procuraArg(args, "-medicoConselho");
        if (pos >= 0 && args.length >= pos + 1 && !Funcoes.textoVazio(args[pos + 1])) {
            ParametrosLocais.setParametro("medicoConselhoPadraoRMI", args[pos + 1]);
            ParametrosLocais.salvaParametros();
        } else if (ParametrosLocais.getParametro("medicoConselhoPadraoRMI") == null || Funcoes.textoVazio(ParametrosLocais.getParametro("medicoCrmPadraoRMI"))) {
            System.out.println("Conselho do m\u00e9dico padr\u00e3o n\u00e3o localizado\n utilize \n -medicoConselho [Conselho] para atualizar o sistema com o conselho do m\u00e9dico padr\u00e3o");
            return;
        }
        if (Funcoes.procuraArg(args, "-log") >= 0) {
            try {
                log = new BufferedWriter(new FileWriter("/var/log/ServidorApoioJalis.log"));
                log.write("Servidor iniciado em " + Funcoes.formataData(new Date()) + " as " + Funcoes.formataHora(new Date(), true) + "\n");
                log.write("Aguardando conexoes...\n");
                log.flush();
            }
            catch (IOException e) {
                log = null;
            }
        }
        if ((pos = Funcoes.procuraArg(args, "-img")) >= 0 && args.length >= pos + 1 && !Funcoes.textoVazio(args[pos + 1])) {
            imagemSuporte = args[pos + 1];
        }
        if (Funcoes.procuraArg(args, "-parcial") >= 0) {
            enviarParcial = true;
        }
        Variaveis.caminhoBanco = "jdbc:postgresql://" + banco + "/jalis";
        new Servidor();
    }

    private static void mostrarHelp() {
        System.out.println("Servidor de conexoes para laboratorios de apoio para o Sistema Jalis");
        System.out.println("Opcoes:");
        System.out.println("\t-help\n\tMostra a ajuda com os parametros disponiveis\n");
        System.out.println("\t--help\n\tMostra a ajuda com os parametros disponiveis\n");
        System.out.println("\t-ip [endereco ip]\n\tIndica ao servidor o caminho (ip) onde esta localizado o banco de dados do Jalis\n\tParametro obrigatorio\n");
        System.out.println("\t-usuario [login]\n\tDefine para o servidor qual o usuario sera utilizado para a gravacao das requisicoes\n\tParametro obrigatorio\n");
        System.out.println("\t-estacao [codigo]\n\tDefine para o servidor o codigo de identificacao da estacao que vai gravar as requisicoes\n\tParametro obrigatorio\n");
        System.out.println("\t-medicoCrm [crm] \n\tDefine o codigo CRM padrao do medico para ser incluido nas requisicoes\n\tParametro obrigatorio\n");
        System.out.println("\t-medicoUF [UF]\n\tDefine o estado (UF) padrao do medico para ser incluido nas requisicoes\n\tParametro obrigatorio\n");
        System.out.println("\t-medicoConselho [conselho]\n\tDefine o conselho padrao do medico para ser incluido nas requisicoes\n\tParametro obrigatorio\n");
        System.out.println("\t-log\n\tGrava um log das conexoes realizadas por laboratorios de apoio");
        System.out.println("\t-verao\n\tInforma ao servidor que o TimeZone padrao sera alterado para contemplar o horario de verao");
        System.out.println("\t-img [arquivo swf]\n\tDefine a imagem do suporte que ser\u00e1 enviada para os clientes");
        System.out.println("\t-parcial\n\tIndica ao cliente do apoio que o servidor vai enviar resultados salvos parcialmente");
    }

    private void registraServidor() {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            ServidorImpl server = new ServidorImpl(log, imagemSuporte, enviarParcial);
            Registry registro = LocateRegistry.createRegistry(4445);
            String nomeServidor = "servidorApoio";
            registro.rebind(nomeServidor, server);
            System.out.println("Aguardando conexoes...");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

